// File: applib.h
//
// Description: Header file for the Microsoft Windows 3.1
//              class library.
//
// Copyright 1992, 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library
//       may be used in compiled form without restrictions.
//       All source rights reserved: Source code to the GUI
//       library can not be distributed (on bulletin boards,
//       or as part of shareware or commercial products)
//       without written permission.
//
//       This software is provided "as is". The user accepts
//       all responsibility for its use.
//

#ifndef __applib
#define __applib

#include <windows.h>

#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include <iostream.h>

extern "C" { void sprintf(...); void exit(int); };

#define output (ios::out)
#define input (ios::in)

LRESULT CALLBACK _export WndProc( HWND hWnd, UINT iMessage,
                  WPARAM wParam, LPARAM lParam );

const int DIALOG_TEXT_LENGTH = 128;
const int DIALOG_MAX_LIST_ITEMS = 64;

class TAppWindow;

class Application
{
 public:
    Application(const char *class_name, char *menu_name = "Menu",
                int num_menu_items = 0,
                char ** menu_items = (char **)NULL);

    // For Windows interface:
    static HANDLE instanceHandle;
    static HANDLE applicationRegisteredFlag;
    static int showWindowFlag;
    static int processEventMessages( void );

    static TAppWindow * get_TAppWindow()
    { return app_window; }
    static void set_TAppWindow(TAppWindow *aw)
    { app_window = aw; }

    enum {DIALOG_TEXT_LENGTH=128, DIALOG_MAX_LIST_ITEMS=64};

    // Class public variables for holding the result of
    // Dialog box functions:
    static char text_from_dialog[DIALOG_TEXT_LENGTH];
    static int selection_from_dialog;
    static char prompt_for_dialog[DIALOG_TEXT_LENGTH];
    static char file_extension_for_dialog[DIALOG_TEXT_LENGTH];
    static char * list_items_for_dialog[DIALOG_MAX_LIST_ITEMS];
    static int number_of_dialog_list_items;

 private:
    static TAppWindow * app_window;
    const char * class_name;

};

const int MAX_TEXT_LINES = 24;
const int MAX_TEXT_LINE_SIZE = 80;

class TAppWindow
{
 protected:
    HWND hWnd;
 private:
    static char windowName[20];
    HBRUSH backgroundBrush;
    HBRUSH blackBrush;
    // Data for supporting scrolling text:
    short top_text_clip, right_text_clip;
    short bottom_text_clip, left_text_clip;
    char *saved_text[MAX_TEXT_LINES]; // ring buffer for
                                      // saved text
    int number_of_saved_lines;
    int current_ring_buffer_start;
    int in_scrolling_text_mode; // =1 for in text mode
    int redraw_both_text_and_graphics;

    void Paint( void );
    // Maintain a valid HDC only during paint operations:
    HDC current_hDC;

 public:
    static void registerWindow( void );
    TAppWindow( void );
    void plot_line(int x1, int y1, int x2, int y2);
    void plot_string(int x, int y, char *cp);
    void plot_rect(int top, int right, int bottom, int left);
    void erase_rect(int top, int right, int bottom, int left);
    int string_height(char *)
      {
         return 13;
      }
    int string_width(char *str)
      {
          return 9 * strlen(str);
      }

    void clear_display();
    void redraw_display();
    HWND GetHandle( void ) { return hWnd; };
    BOOL Show( int showWindowFlag )
    { return ShowWindow( hWnd, showWindowFlag ); };
    void Update( void ) { UpdateWindow( hWnd ); };

    // user defined callback(s):
    void update_display();
    void mouse_down(int, int );
    void mouse_up(int, int );
    void mouse_move(int, int );
    void do_menu_action(int);

    // for the About box:
    void do_about();
    void do_edit(char *prompt, char *str);
    void show_info(char *str) { do_edit(" ", str); }
    int choose_one_from_list(char *prompt,
                             char **list_items,
                             int number_of_items);
    int choose_one(char *prompt1, char *prompt2);
    int choose_file_to_write(char *prompt,
                             char *returned_filename);
    int choose_file_to_read(char *prompt,
                            char *extension,
                            char *returned_filename);

    void init_scrolling_text(int top, int right,
                             int bottom, int left);
    void init_scrolling_text();
    void put_scrolling_text(char *str);
    void reset_scrolling_text();
    void idle_proc();

    // Function ::WndProc needs this, so either make
    // TAppWindow::WndProc public, or make ::WndProc
    // a "friend" of class TAppWindow:
    long WndProc( UINT iMessage, WPARAM wParam, LPARAM lParam );

};

// extern TAppWindow *current_window;

void Warning(char *);

// Use the test shown in Borland C++ examples for getting
// and setting TAppWindow pointers for various memory models:
// (From Borland C++ example programs)

// For small and medium memory models:
#if defined(__SMALL__) || defined(__MEDIUM__)

inline TAppWindow *GetPointer( HWND hWnd )
{
    return (TAppWindow *) GetWindowWord( hWnd, 0 );
}
inline void SetPointer( HWND hWnd, TAppWindow *pWindow )
{
    SetWindowWord( hWnd, 0, (WORD) pWindow );
}
#endif

#if defined(__LARGE__) || defined(__COMPACT__)
inline TAppWindow *GetPointer( HWND hWnd )
{
    return (TAppWindow *) GetWindowLong( hWnd, 0 );
}
inline void SetPointer( HWND hWnd, TAppWindow *pWindow )
{
    SetWindowLong( hWnd, 0, (LONG) pWindow );
}
#endif


#define INIT_PROGRAM(menu_name,num,items) \
int PASCAL WinMain(HANDLE instanceHandle, \
                   HANDLE appRegisteredFlag, \
                   LPSTR lpszCmdLine,\
                   int showWindowFlag )\
{\
    Application my_app("my_app", menu_name, num, items);\
    Application::instanceHandle = instanceHandle;\
    Application::applicationRegisteredFlag = appRegisteredFlag;\
    Application::showWindowFlag = showWindowFlag;\
    TAppWindow MainWnd;

#define RUN_PROGRAM \
    return Application::processEventMessages();

#endif __applib


